#ifndef PARSER_ATP_SST_ITERATORS_H
#define PARSER_ATP_SST_ITERATORS_H

/*
   *  Object          : parser_atp_Sst_iterators.h
   *  State           :  %state%
   *  Creation date   :  Apr  7  2009
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief  This file includes the DH parsing functions  
   *         
   *
   *  \version parser_atp_Sst_iterators.h#1:csrc:3
   *  \author TaniaM
   *  \remarks Copyright (C) 2004 by Discretix Technologies Ltd.
   *           All Rights reserved
   */
/************* Include Files ****************/

#include "msg_defs.h"
#include "SST_SEP_TST.h"
#include "sst_errors.h"
#include "sst_sep_errors.h"

/*****************************************************************************
* Function Name:
*  DX_SEP_PARSER_SST_Iterator
*  
* Inputs:
*  msg - message with all requested parameters.
*
* Outputs: 
*  DxUint32_t - Function error return
*
* Description:
* This function does the parsing for the external application SEPQA_SST_Iterator finction.
* It calls the SEP function with parameters parsed from input message
*
* Algorithm: 
* 1. call to DX_SEP_MNG_SSTGetWorkspaceParams
* 2. allocate memory for GlobalMemBuff for all next needed allocation in the test
* 3. allocate buffer from GlobalMemBuff to data struct
* 4. extract parameters from the message 
* 5. call QA SEP function
* 6. free allocated GlobalMemBuff
* 7. end SEP message and return
******************************************************************************/ 
DxUint32_t DX_SEP_SST_PARSER_Iterator(DxUint32_t* msg);
#endif
